//  2011 IDesign Inc.
// Pytania? Komentarze? Odwied
// http://www.idesign.net

using System;
using System.Diagnostics;
using System.Drawing;
using System.Threading;
using System.Windows.Forms;

namespace ServiceModelEx
{
   /// <summary>
   /// Zapewnia dostp do waciwoci Text z zachowaniem bezpieczestwa typw
   /// </summary>
   [ToolboxBitmap(typeof(SafeLabel),"SafeLabel.bmp")]
   public class SafeLabel : Label
   {
      SynchronizationContext m_SynchronizationContext = SynchronizationContext.Current;
      override public string Text
      {
         set
         {
            try
            {
               m_SynchronizationContext.Send(_=> base.Text = value,null);
            }
            catch
            {}
         }
         get
         {
            string text = String.Empty;
            try
            {
               m_SynchronizationContext.Send(_=> text = base.Text,null);
            }
            catch
            {}
            return text;
         }
      }
   }
}
